﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data;
using System.Data.SqlClient;
using AZVIC.Ei8htPOS.Entities;
using AZVIC.Ei8htPOS.Utilities;

namespace AZVIC.Ei8htPOS.DAL
{
    public class OrdersPaymentDB
    {
        public static OrdersPayment GetItem(Guid ordersPaymentID, Guid ordersID, DateTime fromDate, DateTime endDate)
        {
            OrdersPayment myPay = null;
            List<SqlParameter> parameters = new List<SqlParameter>();
            parameters.Add(new SqlParameter("@OrdersPaymentID", ((ordersPaymentID != Guid.Empty && ordersPaymentID != null) ? ordersPaymentID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@OrdersID", ((ordersID != Guid.Empty && ordersID != null) ? ordersID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@FromDate", (fromDate != null && fromDate != DateTime.MinValue) ? fromDate : (object)DBNull.Value));
            parameters.Add(new SqlParameter("@ToDate", (endDate != null && endDate != DateTime.MinValue) ? endDate : (object)DBNull.Value));

            myPay = SQLHelper.RetrieveObject<OrdersPayment>("spGetOrdersPayment", parameters);
            //For OCBC & NETS Payment
            myPay.OCBCResponse = OCBCHelperDB.GetItem(Guid.Empty, myPay.UniqueID, string.Empty);
            myPay.NETSResponse = NETSHelperDB.GetItem(Guid.Empty, myPay.UniqueID, string.Empty);

            return myPay;
        }

        public static List<OrdersPayment> GetList(Guid ordersPaymentID, Guid ordersID, DateTime fromDate, DateTime endDate)
        {
            List<OrdersPayment> myList = null;

            List<SqlParameter> parameters = new List<SqlParameter>();
            parameters.Add(new SqlParameter("@OrdersPaymentID", ((ordersPaymentID != Guid.Empty && ordersPaymentID != null) ? ordersPaymentID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@OrdersID", ((ordersID != Guid.Empty && ordersID != null) ? ordersID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@FromDate", (fromDate != null && fromDate != DateTime.MinValue) ? fromDate : (object)DBNull.Value));
            parameters.Add(new SqlParameter("@ToDate", (endDate != null && endDate != DateTime.MinValue) ? endDate : (object)DBNull.Value));

            myList = SQLHelper.RetrieveList<OrdersPayment>("spGetOrdersPayment", parameters);
            //For OCBC & NETS Pay
            foreach (OrdersPayment currentTransaction in myList)
            {
                currentTransaction.OCBCResponse = OCBCHelperDB.GetItem(Guid.Empty, currentTransaction.UniqueID, string.Empty);
                currentTransaction.NETSResponse = NETSHelperDB.GetItem(Guid.Empty, currentTransaction.UniqueID, string.Empty);
            }

            return myList;
        }

        public static DataTable GetDataTable(Guid ordersPaymentID, Guid ordersID, DateTime fromDate, DateTime endDate)
        {
            List<SqlParameter> parameters = new List<SqlParameter>();
            parameters.Add(new SqlParameter("@OrdersPaymentID", ((ordersPaymentID != Guid.Empty && ordersPaymentID != null) ? ordersPaymentID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@OrdersID", ((ordersID != Guid.Empty && ordersID != null) ? ordersID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@FromDate", (fromDate != null && fromDate != DateTime.MinValue) ? fromDate : (object)DBNull.Value));
            parameters.Add(new SqlParameter("@ToDate", (endDate != null && endDate != DateTime.MinValue) ? endDate : (object)DBNull.Value));

            return SQLHelper.ExecuteDataTable("spGetOrdersPayment", parameters);
        }

        public static DataSet GetDataSet(Guid ordersPaymentID, Guid ordersID, DateTime fromDate, DateTime endDate)
        {
            List<SqlParameter> parameters = new List<SqlParameter>();
            parameters.Add(new SqlParameter("@OrdersPaymentID", ((ordersPaymentID != Guid.Empty && ordersPaymentID != null) ? ordersPaymentID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@OrdersID", ((ordersID != Guid.Empty && ordersID != null) ? ordersID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@FromDate", (fromDate != null && fromDate != DateTime.MinValue) ? fromDate : (object)DBNull.Value));
            parameters.Add(new SqlParameter("@ToDate", (endDate != null && endDate != DateTime.MinValue) ? endDate : (object)DBNull.Value));

            return SQLHelper.ExecuteDataSet("spGetOrdersPayment", parameters);
        }

        public static void Save(OrdersPayment myOrdersPayment)
        {
            myOrdersPayment.Mode = ((myOrdersPayment.UniqueID != Guid.Empty && myOrdersPayment.UniqueID != null) ? GlobalConfigurations.Mode.Update : GlobalConfigurations.Mode.Insert);
            myOrdersPayment.UniqueID = ((myOrdersPayment.UniqueID != Guid.Empty && myOrdersPayment.UniqueID != null) ? myOrdersPayment.UniqueID : Guid.NewGuid());
            if (myOrdersPayment.Mode == GlobalConfigurations.Mode.Insert)
            {
                myOrdersPayment.IsActive = true;
                //myOrders.IsDeleted = false;
            }

            List<SqlParameter> parameters = new List<SqlParameter>();

            parameters.Add(new SqlParameter("@OrdersPaymentID", myOrdersPayment.UniqueID));
            parameters.Add(new SqlParameter("@OrdersID", ((myOrdersPayment.OrdersID != Guid.Empty && myOrdersPayment.OrdersID != null) ? myOrdersPayment.OrdersID : (object)DBNull.Value)));

            parameters.Add(new SqlParameter("@PaidAmount", (myOrdersPayment.PaidAmount == 0 ? (object)DBNull.Value : myOrdersPayment.PaidAmount)));
            parameters.Add(new SqlParameter("@PaymentMethod", (string.IsNullOrEmpty(myOrdersPayment.PaymentMethod) ? (object)DBNull.Value : myOrdersPayment.PaymentMethod)));
            parameters.Add(new SqlParameter("@PaymentType", (string.IsNullOrEmpty(myOrdersPayment.PaymentType) ? (object)DBNull.Value : myOrdersPayment.PaymentType)));
            parameters.Add(new SqlParameter("@PaymentStatus", (string.IsNullOrEmpty(myOrdersPayment.PaymentStatus) ? (object)DBNull.Value : myOrdersPayment.PaymentStatus)));
            parameters.Add(new SqlParameter("@TransactionReference", (string.IsNullOrEmpty(myOrdersPayment.TransactionReference) ? (object)DBNull.Value : myOrdersPayment.TransactionReference)));
            parameters.Add(new SqlParameter("@Comments", (string.IsNullOrEmpty(myOrdersPayment.Comments) ? (object)DBNull.Value : myOrdersPayment.Comments)));
            parameters.Add(new SqlParameter("@CreatedBy", ((myOrdersPayment.AdminUserAccountID != Guid.Empty && myOrdersPayment.AdminUserAccountID != null) ? myOrdersPayment.AdminUserAccountID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@IsActive", myOrdersPayment.IsActive));
            //parameters.Add(new SqlParameter("@IsDeleted", myOrders.IsDeleted));

            SQLHelper.ExecuteQuery("spAddOrUpdateOrdersPayment", parameters);
        }
    }
}
